/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.parsson;

import jakarta.json.JsonArray;
import jakarta.json.JsonException;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonParser;
import jakarta.json.stream.JsonParsingException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import org.eclipse.parsson.JsonContext;
import org.eclipse.parsson.JsonMessages;
import org.eclipse.parsson.JsonParserImpl;

class JsonReaderImpl
implements JsonReader {
    private final JsonParserImpl parser;
    private boolean readDone;

    JsonReaderImpl(Reader reader, JsonContext jsonContext) {
        this.parser = new JsonParserImpl(reader, jsonContext);
    }

    JsonReaderImpl(InputStream in, JsonContext jsonContext) {
        this.parser = new JsonParserImpl(in, jsonContext);
    }

    JsonReaderImpl(InputStream in, Charset charset, JsonContext jsonContext) {
        this.parser = new JsonParserImpl(in, charset, jsonContext);
    }

    @Override
    public JsonStructure read() {
        if (this.readDone) {
            throw new IllegalStateException(JsonMessages.READER_READ_ALREADY_CALLED());
        }
        this.readDone = true;
        if (this.parser.hasNext()) {
            try {
                JsonParser.Event e = this.parser.next();
                if (e == JsonParser.Event.START_ARRAY) {
                    return this.parser.getArray();
                }
                if (e == JsonParser.Event.START_OBJECT) {
                    return this.parser.getObject();
                }
            }
            catch (IllegalStateException ise) {
                throw new JsonParsingException(ise.getMessage(), ise, this.parser.getLastCharLocation());
            }
        }
        throw new JsonException(JsonMessages.INTERNAL_ERROR());
    }

    @Override
    public JsonObject readObject() {
        if (this.readDone) {
            throw new IllegalStateException(JsonMessages.READER_READ_ALREADY_CALLED());
        }
        this.readDone = true;
        if (this.parser.hasNext()) {
            try {
                this.parser.next();
                return this.parser.getObject();
            }
            catch (IllegalStateException ise) {
                throw new JsonParsingException(ise.getMessage(), ise, this.parser.getLastCharLocation());
            }
        }
        throw new JsonException(JsonMessages.INTERNAL_ERROR());
    }

    @Override
    public JsonArray readArray() {
        if (this.readDone) {
            throw new IllegalStateException(JsonMessages.READER_READ_ALREADY_CALLED());
        }
        this.readDone = true;
        if (this.parser.hasNext()) {
            try {
                this.parser.next();
                return this.parser.getArray();
            }
            catch (IllegalStateException ise) {
                throw new JsonParsingException(ise.getMessage(), ise, this.parser.getLastCharLocation());
            }
        }
        throw new JsonException(JsonMessages.INTERNAL_ERROR());
    }

    @Override
    public JsonValue readValue() {
        if (this.readDone) {
            throw new IllegalStateException(JsonMessages.READER_READ_ALREADY_CALLED());
        }
        this.readDone = true;
        if (this.parser.hasNext()) {
            try {
                this.parser.next();
                return this.parser.getValue();
            }
            catch (IllegalStateException ise) {
                throw new JsonParsingException(ise.getMessage(), ise, this.parser.getLastCharLocation());
            }
        }
        throw new JsonException(JsonMessages.INTERNAL_ERROR());
    }

    @Override
    public void close() {
        this.readDone = true;
        this.parser.close();
    }
}

