/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import javax.swing.JCheckBoxMenuItem;
import org.openstreetmap.josm.actions.ToggleAction;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.spi.preferences.PreferenceChangeEvent;
import org.openstreetmap.josm.spi.preferences.PreferenceChangedListener;
import org.openstreetmap.josm.tools.ImageProvider;

public class PreferenceToggleAction
extends ToggleAction
implements PreferenceChangedListener {
    private final JCheckBoxMenuItem checkbox;
    private final BooleanProperty pref;

    public PreferenceToggleAction(String name, String tooltip, BooleanProperty pref) {
        this(name, null, tooltip, pref);
    }

    public PreferenceToggleAction(String name, ImageProvider icon, String tooltip, BooleanProperty pref) {
        super(name, icon, tooltip, null, false, null, true);
        this.setToolbarId("toggle-" + pref.getKey());
        this.pref = pref;
        this.checkbox = new JCheckBoxMenuItem(this);
        this.checkbox.setSelected(pref.get());
        Preferences.main().addWeakKeyPreferenceChangeListener(pref.getKey(), this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.pref.put(this.checkbox.isSelected());
    }

    public JCheckBoxMenuItem getCheckbox() {
        return this.checkbox;
    }

    @Override
    public void preferenceChanged(PreferenceChangeEvent e) {
        this.checkbox.setSelected(this.pref.get());
    }
}

