/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.gpx;

import java.awt.Color;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.ILatLon;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.WithAttributes;
import org.openstreetmap.josm.data.osm.search.SearchCompiler;
import org.openstreetmap.josm.data.projection.Projecting;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.template_engine.TemplateEngineDataProvider;

public class WayPoint
extends WithAttributes
implements Comparable<WayPoint>,
TemplateEngineDataProvider,
ILatLon {
    public Color customColoring;
    public boolean drawLine;
    public int dir;
    private final double lat;
    private final double lon;
    private double east = Double.NaN;
    private double north = Double.NaN;
    private Object eastNorthCacheKey;

    public WayPoint(WayPoint p) {
        this.attr = new HashMap(0);
        this.attr.putAll(p.attr);
        this.lat = p.lat;
        this.lon = p.lon;
        this.east = p.east;
        this.north = p.north;
        this.eastNorthCacheKey = p.eastNorthCacheKey;
        this.customColoring = p.customColoring;
        this.drawLine = p.drawLine;
        this.dir = p.dir;
    }

    public WayPoint(LatLon ll) {
        this.attr = new HashMap(0);
        this.lat = ll.lat();
        this.lon = ll.lon();
    }

    public void invalidateEastNorthCache() {
        this.east = Double.NaN;
        this.north = Double.NaN;
    }

    public final LatLon getCoor() {
        return new LatLon(this.lat, this.lon);
    }

    @Override
    public double lon() {
        return this.lon;
    }

    @Override
    public double lat() {
        return this.lat;
    }

    @Override
    public final EastNorth getEastNorth(Projecting projecting) {
        Object newCacheKey = projecting.getCacheKey();
        if (Double.isNaN(this.east) || Double.isNaN(this.north) || !Objects.equals(newCacheKey, this.eastNorthCacheKey)) {
            EastNorth en = projecting.latlon2eastNorth(this);
            this.east = en.east();
            this.north = en.north();
            this.eastNorthCacheKey = newCacheKey;
        }
        return new EastNorth(this.east, this.north);
    }

    public String toString() {
        return "WayPoint (" + (String)(this.attr.containsKey("name") ? String.valueOf(this.get("name")) + ", " : "") + String.valueOf(this.getCoor()) + ", " + String.valueOf(this.attr) + ")";
    }

    public void setTimeInMillis(long ts) {
        this.setInstant(Instant.ofEpochMilli(ts));
    }

    public void setInstant(Instant instant) {
        this.attr.put("time", instant);
    }

    @Override
    public int compareTo(WayPoint w) {
        return Long.compare(this.getTimeInMillis(), w.getTimeInMillis());
    }

    public double getTime() {
        return (double)this.getTimeInMillis() / 1000.0;
    }

    public long getTimeInMillis() {
        Instant d = this.getInstant();
        return d == null ? 0L : d.toEpochMilli();
    }

    public boolean hasDate() {
        return this.attr.get("time") instanceof Instant;
    }

    public Instant getInstant() {
        if (this.attr != null) {
            Object obj = this.attr.get("time");
            if (obj instanceof Instant) {
                return (Instant)obj;
            }
            if (obj == null) {
                Logging.trace("Waypoint {0} value unset", "time");
            } else {
                Logging.warn("Unsupported waypoint {0} value: {1}", "time", obj);
            }
        }
        return null;
    }

    @Override
    public Object getTemplateValue(String name, boolean special) {
        if (special) {
            return null;
        }
        if ("desc".equals(name)) {
            Object value = this.get(name);
            return value instanceof String ? Utils.stripHtml((String)value) : value;
        }
        return this.get(name);
    }

    @Override
    public boolean evaluateCondition(SearchCompiler.Match condition) {
        throw new UnsupportedOperationException();
    }

    public List<String> getTemplateKeys() {
        return new ArrayList<String>(this.attr.keySet());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.lat, this.lon, this.getTimeInMillis());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !super.equals(obj) || this.getClass() != obj.getClass()) {
            return false;
        }
        WayPoint other = (WayPoint)obj;
        return Double.doubleToLongBits(this.lat) == Double.doubleToLongBits(other.lat) && Double.doubleToLongBits(this.lon) == Double.doubleToLongBits(other.lon) && this.getTimeInMillis() == other.getTimeInMillis();
    }
}

