/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.history;

import java.text.MessageFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationData;
import org.openstreetmap.josm.data.osm.RelationMemberData;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.data.osm.history.HistoryNameFormatter;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class HistoryRelation
extends HistoryOsmPrimitive {
    private final List<RelationMemberData> members = new ArrayList<RelationMemberData>();

    public HistoryRelation(long id, long version, boolean visible, User user, long changesetId, Instant timestamp) {
        super(id, version, visible, user, changesetId, timestamp);
    }

    public HistoryRelation(long id, long version, boolean visible, User user, long changesetId, Instant timestamp, boolean checkHistoricParams) {
        super(id, version, visible, user, changesetId, timestamp, checkHistoricParams);
    }

    public HistoryRelation(long id, long version, boolean visible, User user, long changesetId, Instant timestamp, List<RelationMemberData> members) {
        this(id, version, visible, user, changesetId, timestamp);
        if (members != null) {
            this.members.addAll(members);
        }
    }

    public HistoryRelation(Relation r) {
        super(r);
    }

    public List<RelationMemberData> getMembers() {
        return Collections.unmodifiableList(this.members);
    }

    public int getNumMembers() {
        return this.members.size();
    }

    public RelationMemberData getRelationMember(int idx) {
        if (idx < 0 || idx >= this.members.size()) {
            throw new IndexOutOfBoundsException(MessageFormat.format("Parameter {0} not in range 0..{1}. Got ''{2}''.", "idx", this.members.size(), idx));
        }
        return this.members.get(idx);
    }

    @Override
    public OsmPrimitiveType getType() {
        return OsmPrimitiveType.RELATION;
    }

    public void addMember(RelationMemberData member) {
        CheckParameterUtil.ensureParameterNotNull(member, "member");
        this.members.add(member);
    }

    @Override
    public String getDisplayName(HistoryNameFormatter formatter) {
        return formatter.format(this);
    }

    public RelationData fillPrimitiveData(RelationData data) {
        super.fillPrimitiveCommonData(data);
        data.setMembers(this.members);
        return data;
    }
}

