/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GridBagLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;
import org.openstreetmap.josm.gui.widgets.UrlLabel;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.TextUtils;

public class AlignImageryPanel
extends JPanel {
    public AlignImageryPanel(boolean oneLine, BooleanProperty showAgain, ImageryInfo infoToAdd) {
        Font font = this.getFont().deriveFont(0, 14.0f);
        JMultilineLabel nagLabel = new JMultilineLabel(I18n.tr("Aerial imagery \"{0}\" might be misaligned. Please check its offset using GPS tracks!", TextUtils.wrapLongUrl(infoToAdd.getName())));
        UrlLabel detailsList = new UrlLabel(I18n.tr("http://wiki.openstreetmap.org/wiki/Using_Imagery", new Object[0]), I18n.tr("Details...", new Object[0]));
        nagLabel.setFont(font);
        nagLabel.setForeground(Color.BLACK);
        detailsList.setFont(font);
        JCheckBox doNotShowAgain = new JCheckBox(I18n.tr("Do not show this message again", new Object[0]));
        doNotShowAgain.setOpaque(false);
        doNotShowAgain.setForeground(Color.BLACK);
        JButton closeButton = new JButton(ImageProvider.get("misc", "black_x"));
        closeButton.setContentAreaFilled(false);
        closeButton.setRolloverEnabled(true);
        closeButton.setBorderPainted(false);
        closeButton.setCursor(Cursor.getPredefinedCursor(12));
        closeButton.setToolTipText(I18n.tr("Hide this message", new Object[0]));
        closeButton.addActionListener(e -> {
            if (MainApplication.isDisplayingMapView()) {
                MainApplication.getMap().removeTopPanel(AlignImageryPanel.class);
                if (doNotShowAgain.isSelected()) {
                    showAgain.put(Boolean.FALSE);
                }
            }
        });
        this.setLayout(new GridBagLayout());
        if (!oneLine) {
            this.add((Component)nagLabel, GBC.std(1, 1).fill());
            this.add((Component)detailsList, GBC.std(1, 2).fill());
            this.add((Component)doNotShowAgain, GBC.std(1, 3).fill());
            this.add((Component)closeButton, GBC.std(2, 1).span(1, 2).anchor(13));
        } else {
            this.add((Component)nagLabel, GBC.std(1, 1).fill());
            this.add((Component)detailsList, GBC.std(2, 1).fill());
            this.add((Component)doNotShowAgain, GBC.std(1, 2).fill());
            this.add((Component)closeButton, GBC.std(3, 1).anchor(13));
        }
        this.setBorder(new CompoundBorder(new EtchedBorder(1), new EmptyBorder(12, 12, 12, 12)));
        this.setBackground(new Color(224, 236, 249));
    }

    public static void addNagPanelIfNeeded(ImageryInfo infoToAdd) {
        BooleanProperty showAgain = new BooleanProperty("message.imagery.nagPanel." + infoToAdd.getUrl(), true);
        MapFrame map = MainApplication.getMap();
        if (MainApplication.isDisplayingMapView() && Boolean.TRUE.equals(showAgain.get()) && !infoToAdd.isGeoreferenceValid() && map.getTopPanel(AlignImageryPanel.class) == null) {
            SwingUtilities.invokeLater(() -> {
                double w = map.getWidth();
                map.addTopPanel(new AlignImageryPanel(w > 1300.0, showAgain, infoToAdd));
            });
        }
    }
}

