/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.geoimage;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.spi.preferences.IPreferences;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class AdvancedCorrelationSettingsDialog
extends ExtendedDialog {
    private JCheckBox cInterpolSeg;
    private JCheckBox cInterpolSegTime;
    private JSpinner sInterpolSegTime;
    private JCheckBox cInterpolSegDist;
    private JSpinner sInterpolSegDist;
    private JCheckBox cTagSeg;
    private JCheckBox cTagSegTime;
    private JSpinner sTagSegTime;
    private JCheckBox cInterpolTrack;
    private JCheckBox cInterpolTrackTime;
    private JSpinner sInterpolTrackTime;
    private JCheckBox cInterpolTrackDist;
    private JSpinner sInterpolTrackDist;
    private JCheckBox cTagTrack;
    private JCheckBox cTagTrackTime;
    private JSpinner sTagTrackTime;
    private JCheckBox cForce;

    public AdvancedCorrelationSettingsDialog(Component parent, boolean forceTags) {
        super(parent, I18n.tr("Advanced settings", new Object[0]), I18n.tr("OK", new Object[0]), I18n.tr("Cancel", new Object[0]));
        this.setButtonIcons("ok", "cancel");
        this.setContent(this.buildContent(forceTags));
    }

    private Component buildContent(boolean forceTags) {
        IPreferences s = Config.getPref();
        JPanel p = new JPanel(new GridBagLayout());
        Border border1 = BorderFactory.createEmptyBorder(0, 20, 0, 0);
        Border border2 = BorderFactory.createEmptyBorder(10, 0, 5, 0);
        Border border = BorderFactory.createEmptyBorder(0, 40, 0, 0);
        FlowLayout layout = new FlowLayout();
        JLabel l = new JLabel(I18n.tr("Segment settings", new Object[0]));
        l.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        p.add((Component)l, GBC.eol());
        this.cInterpolSeg = new JCheckBox(I18n.tr("Interpolate between segments", new Object[0]), s.getBoolean("geoimage.seg.int", true));
        this.cInterpolSeg.setBorder(border1);
        p.add((Component)this.cInterpolSeg, GBC.eol());
        this.cInterpolSegTime = new JCheckBox(I18n.tr("only when the segments are less than # minutes apart:", new Object[0]), s.getBoolean("geoimage.seg.int.time", true));
        this.sInterpolSegTime = new JSpinner(new SpinnerNumberModel(s.getInt("geoimage.seg.int.time.val", 60), 0, Integer.MAX_VALUE, 1));
        ((JSpinner.DefaultEditor)this.sInterpolSegTime.getEditor()).getTextField().setColumns(3);
        JPanel pInterpolSegTime = new JPanel(layout);
        pInterpolSegTime.add(this.cInterpolSegTime);
        pInterpolSegTime.add(this.sInterpolSegTime);
        pInterpolSegTime.setBorder(border);
        p.add((Component)pInterpolSegTime, GBC.eol());
        this.cInterpolSegDist = new JCheckBox(I18n.tr("only when the segments are less than # meters apart:", new Object[0]), s.getBoolean("geoimage.seg.int.dist", true));
        this.sInterpolSegDist = new JSpinner(new SpinnerNumberModel(s.getInt("geoimage.seg.int.dist.val", 50), 0, Integer.MAX_VALUE, 1));
        ((JSpinner.DefaultEditor)this.sInterpolSegDist.getEditor()).getTextField().setColumns(3);
        JPanel pInterpolSegDist = new JPanel(layout);
        pInterpolSegDist.add(this.cInterpolSegDist);
        pInterpolSegDist.add(this.sInterpolSegDist);
        pInterpolSegDist.setBorder(border);
        p.add((Component)pInterpolSegDist, GBC.eol());
        this.cTagSeg = new JCheckBox(I18n.tr("Tag images at the closest end of a segment, when not interpolated", new Object[0]), s.getBoolean("geoimage.seg.tag", true));
        this.cTagSeg.setBorder(border1);
        p.add((Component)this.cTagSeg, GBC.eol());
        this.cTagSegTime = new JCheckBox(I18n.tr("only within # minutes of the closest trackpoint:", new Object[0]), s.getBoolean("geoimage.seg.tag.time", true));
        this.sTagSegTime = new JSpinner(new SpinnerNumberModel(s.getInt("geoimage.seg.tag.time.val", 2), 0, Integer.MAX_VALUE, 1));
        ((JSpinner.DefaultEditor)this.sTagSegTime.getEditor()).getTextField().setColumns(3);
        JPanel pTagSegTime = new JPanel(layout);
        pTagSegTime.add(this.cTagSegTime);
        pTagSegTime.add(this.sTagSegTime);
        pTagSegTime.setBorder(border);
        p.add((Component)pTagSegTime, GBC.eol());
        l = new JLabel(I18n.tr("Track settings (note that multiple tracks can be in one GPX file)", new Object[0]));
        l.setBorder(border2);
        p.add((Component)l, GBC.eol());
        this.cInterpolTrack = new JCheckBox(I18n.tr("Interpolate between tracks", new Object[0]), s.getBoolean("geoimage.trk.int", false));
        this.cInterpolTrack.setBorder(border1);
        p.add((Component)this.cInterpolTrack, GBC.eol());
        this.cInterpolTrackTime = new JCheckBox(I18n.tr("only when the tracks are less than # minutes apart:", new Object[0]), s.getBoolean("geoimage.trk.int.time", false));
        this.sInterpolTrackTime = new JSpinner(new SpinnerNumberModel(s.getInt("geoimage.trk.int.time.val", 60), 0, Integer.MAX_VALUE, 1));
        ((JSpinner.DefaultEditor)this.sInterpolTrackTime.getEditor()).getTextField().setColumns(3);
        JPanel pInterpolTrackTime = new JPanel(layout);
        pInterpolTrackTime.add(this.cInterpolTrackTime);
        pInterpolTrackTime.add(this.sInterpolTrackTime);
        pInterpolTrackTime.setBorder(border);
        p.add((Component)pInterpolTrackTime, GBC.eol());
        this.cInterpolTrackDist = new JCheckBox(I18n.tr("only when the tracks are less than # meters apart:", new Object[0]), s.getBoolean("geoimage.trk.int.dist", false));
        this.sInterpolTrackDist = new JSpinner(new SpinnerNumberModel(s.getInt("geoimage.trk.int.dist.val", 50), 0, Integer.MAX_VALUE, 1));
        ((JSpinner.DefaultEditor)this.sInterpolTrackDist.getEditor()).getTextField().setColumns(3);
        JPanel pInterpolTrackDist = new JPanel(layout);
        pInterpolTrackDist.add(this.cInterpolTrackDist);
        pInterpolTrackDist.add(this.sInterpolTrackDist);
        pInterpolTrackDist.setBorder(border);
        p.add((Component)pInterpolTrackDist, GBC.eol());
        this.cTagTrack = new JCheckBox("<html>" + I18n.tr("Tag images at the closest end of a track, when not interpolated<br>(also applies before the first and after the last track)", new Object[0]) + "</html>", s.getBoolean("geoimage.trk.tag", true));
        this.cTagTrack.setBorder(border1);
        p.add((Component)this.cTagTrack, GBC.eol());
        this.cTagTrackTime = new JCheckBox(I18n.tr("only within # minutes of the closest trackpoint:", new Object[0]), s.getBoolean("geoimage.trk.tag.time", true));
        this.sTagTrackTime = new JSpinner(new SpinnerNumberModel(s.getInt("geoimage.trk.tag.time.val", 2), 0, Integer.MAX_VALUE, 1));
        ((JSpinner.DefaultEditor)this.sTagTrackTime.getEditor()).getTextField().setColumns(3);
        JPanel pTagTrackTime = new JPanel(layout);
        pTagTrackTime.add(this.cTagTrackTime);
        pTagTrackTime.add(this.sTagTrackTime);
        pTagTrackTime.setBorder(border);
        p.add((Component)pTagTrackTime, GBC.eol());
        l = new JLabel(I18n.tr("Advanced", new Object[0]));
        l.setBorder(border2);
        p.add((Component)l, GBC.eol());
        this.cForce = new JCheckBox("<html>" + I18n.tr("Force tagging of all pictures (temporarily overrides the settings above).", new Object[0]) + "<br>" + I18n.tr("This option will not be saved permanently.", new Object[0]) + "</html>", forceTags);
        this.cForce.setBorder(BorderFactory.createEmptyBorder(0, 20, 10, 0));
        p.add((Component)this.cForce, GBC.eol());
        AdvancedCorrelationSettingsDialog.addCheckBoxActionListener(this.cInterpolSegTime, this.sInterpolSegTime);
        AdvancedCorrelationSettingsDialog.addCheckBoxActionListener(this.cInterpolSegDist, this.sInterpolSegDist);
        AdvancedCorrelationSettingsDialog.addCheckBoxActionListener(this.cInterpolSeg, pInterpolSegTime, pInterpolSegDist);
        AdvancedCorrelationSettingsDialog.addCheckBoxActionListener(this.cTagSegTime, this.sTagSegTime);
        AdvancedCorrelationSettingsDialog.addCheckBoxActionListener(this.cTagSeg, pTagSegTime);
        AdvancedCorrelationSettingsDialog.addCheckBoxActionListener(this.cInterpolTrackTime, this.sInterpolTrackTime);
        AdvancedCorrelationSettingsDialog.addCheckBoxActionListener(this.cInterpolTrackDist, this.sInterpolTrackDist);
        AdvancedCorrelationSettingsDialog.addCheckBoxActionListener(this.cInterpolTrack, pInterpolTrackTime, pInterpolTrackDist);
        AdvancedCorrelationSettingsDialog.addCheckBoxActionListener(this.cTagTrackTime, this.sTagTrackTime);
        AdvancedCorrelationSettingsDialog.addCheckBoxActionListener(this.cTagTrack, pTagTrackTime);
        return p;
    }

    @Override
    protected void buttonAction(int buttonIndex, ActionEvent evt) {
        super.buttonAction(buttonIndex, evt);
        if (buttonIndex == 0) {
            IPreferences s = Config.getPref();
            s.putBoolean("geoimage.seg.int", this.cInterpolSeg.isSelected());
            s.putBoolean("geoimage.seg.int.dist", this.cInterpolSegDist.isSelected());
            s.putInt("geoimage.seg.int.dist.val", (Integer)this.sInterpolSegDist.getValue());
            s.putBoolean("geoimage.seg.int.time", this.cInterpolSegTime.isSelected());
            s.putInt("geoimage.seg.int.time.val", (Integer)this.sInterpolSegTime.getValue());
            s.putBoolean("geoimage.seg.tag", this.cTagSeg.isSelected());
            s.putBoolean("geoimage.seg.tag.time", this.cTagSegTime.isSelected());
            s.putInt("geoimage.seg.tag.time.val", (Integer)this.sTagSegTime.getValue());
            s.putBoolean("geoimage.trk.int", this.cInterpolTrack.isSelected());
            s.putBoolean("geoimage.trk.int.dist", this.cInterpolTrackDist.isSelected());
            s.putInt("geoimage.trk.int.dist.val", (Integer)this.sInterpolTrackDist.getValue());
            s.putBoolean("geoimage.trk.int.time", this.cInterpolTrackTime.isSelected());
            s.putInt("geoimage.trk.int.time.val", (Integer)this.sInterpolTrackTime.getValue());
            s.putBoolean("geoimage.trk.tag", this.cTagTrack.isSelected());
            s.putBoolean("geoimage.trk.tag.time", this.cTagTrackTime.isSelected());
            s.putInt("geoimage.trk.tag.time.val", (Integer)this.sTagTrackTime.getValue());
        }
    }

    public boolean isForceTaggingSelected() {
        return this.cForce.isSelected();
    }

    protected static void addCheckBoxActionListener(JCheckBox cb, JComponent ... c) {
        CheckBoxActionListener listener = new CheckBoxActionListener(c);
        cb.addActionListener(listener);
        listener.setEnabled(cb);
    }

    protected static class CheckBoxActionListener
    implements ActionListener {
        private final JComponent[] comps;

        CheckBoxActionListener(JComponent ... c) {
            this.comps = Objects.requireNonNull(c);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.setEnabled((JCheckBox)e.getSource());
        }

        public void setEnabled(JCheckBox cb) {
            for (JComponent comp : this.comps) {
                if (comp instanceof JSpinner) {
                    comp.setEnabled(cb.isSelected());
                    continue;
                }
                if (!(comp instanceof JPanel)) continue;
                boolean en = cb.isSelected();
                for (Component c : comp.getComponents()) {
                    if (c instanceof JSpinner) {
                        c.setEnabled(en);
                        continue;
                    }
                    c.setEnabled(cb.isSelected());
                    if (!en || !(c instanceof JCheckBox)) continue;
                    en = ((JCheckBox)c).isSelected();
                }
            }
        }
    }
}

