/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.geoimage.viewers.projections;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentListener;
import java.awt.image.BufferedImage;
import java.util.Set;
import org.openstreetmap.josm.data.imagery.street_level.Projections;
import org.openstreetmap.josm.gui.layer.geoimage.ImageDisplay;
import org.openstreetmap.josm.gui.util.imagery.Vector3D;

public interface IImageViewer
extends ComponentListener {
    public Set<Projections> getSupportedProjections();

    public void paintImage(Graphics var1, BufferedImage var2, Rectangle var3, Rectangle var4);

    public ImageDisplay.VisRect getDefaultVisibleRectangle(Component var1, Image var2);

    default public Vector3D getRotation() {
        return null;
    }

    default public void mouseDragged(Point from, Point to, ImageDisplay.VisRect currentVisibleRect) {
        currentVisibleRect.isDragUpdate = true;
        currentVisibleRect.x += from.x - to.x;
        currentVisibleRect.y += from.y - to.y;
    }

    default public void checkAndModifyVisibleRectSize(Image image, ImageDisplay.VisRect visibleRect) {
        if (visibleRect.width > image.getWidth(null)) {
            visibleRect.width = image.getWidth(null);
        }
        if (visibleRect.height > image.getHeight(null)) {
            visibleRect.height = image.getHeight(null);
        }
    }

    default public Image getMaxImageSize(ImageDisplay imageDisplay, Image image) {
        return image;
    }
}

