/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import javax.swing.JMenu;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.mappaint.StyleSetting;
import org.openstreetmap.josm.gui.mappaint.StyleSettingGui;
import org.openstreetmap.josm.gui.mappaint.loader.MapPaintStyleLoader;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class ColorStyleSettingGui
implements StyleSettingGui {
    private final StyleSetting.ColorStyleSetting setting;

    public ColorStyleSettingGui(StyleSetting.ColorStyleSetting setting) {
        this.setting = Objects.requireNonNull(setting);
    }

    @Override
    public void addMenuEntry(JMenu menu) {
        menu.add(new ColorStyleSettingAction());
    }

    class ColorStyleSettingAction
    extends AbstractAction {
        ColorStyleSettingAction() {
            super(ColorStyleSettingGui.this.setting.label, new ColorIcon((Color)ColorStyleSettingGui.this.setting.getValue(), ImageProvider.ImageSizes.SMALLICON));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ColorStyleSettingGui.this.setting.setValue(JColorChooser.showDialog(MainApplication.getMainPanel(), I18n.tr("Choose a color", new Object[0]), (Color)ColorStyleSettingGui.this.setting.getValue()));
            MainApplication.worker.submit(new MapPaintStyleLoader(Collections.singleton(ColorStyleSettingGui.this.setting.parentStyle)));
        }
    }

    static class ColorIcon
    implements Icon {
        private final Color color;
        private final ImageProvider.ImageSizes size;

        ColorIcon(Color color, ImageProvider.ImageSizes size) {
            this.color = color;
            this.size = size;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Color current = g.getColor();
            g.setColor(this.color);
            g.drawRect(x, y, this.getIconWidth(), this.getIconHeight());
            g.fillRect(x, y, this.getIconWidth(), this.getIconHeight());
            g.setColor(current);
        }

        @Override
        public int getIconWidth() {
            return this.size.getAdjustedWidth();
        }

        @Override
        public int getIconHeight() {
            return this.size.getAdjustedHeight();
        }
    }
}

