/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.lists;

import com.sun.electric.tool.ncc.NccGlobals;
import com.sun.electric.tool.ncc.lists.RecordList;
import com.sun.electric.tool.ncc.trees.EquivRecord;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;

public class LeafList
extends RecordList {
    @Override
    public void add(EquivRecord r) {
        this.error(!r.isLeaf(), "EquivList only allows leaves");
        super.add(r);
    }

    public void sortByIncreasingSize() {
        Collections.sort(this.content, new SizeCompare());
    }

    public String sizeInfoString() {
        StringBuffer max2 = new StringBuffer(" offspring max sizes:");
        StringBuffer diff2 = new StringBuffer(" offspring size differences: ");
        boolean matchOK = true;
        Iterator<EquivRecord> it = this.iterator();
        while (it.hasNext()) {
            EquivRecord g = it.next();
            max2.append(" " + g.maxSize());
            diff2.append(" " + g.maxSizeDiff());
            if (g.maxSizeDiff() <= 0) continue;
            matchOK = false;
        }
        if (matchOK) {
            return max2.toString();
        }
        return max2 + "\n" + diff2 + "\n WARNING: Mismatched sizes";
    }

    public LeafList selectActive(NccGlobals globals) {
        LeafList out = new LeafList();
        Iterator<EquivRecord> it = this.iterator();
        while (it.hasNext()) {
            EquivRecord er = it.next();
            if (!er.isActive()) continue;
            out.add(er);
        }
        globals.status2(" selectActive found " + out.size() + " active leaf records");
        return out;
    }

    public LeafList selectMatched(NccGlobals globals) {
        LeafList out = new LeafList();
        Iterator<EquivRecord> it = this.iterator();
        while (it.hasNext()) {
            EquivRecord er = it.next();
            if (!er.isMatched()) continue;
            out.add(er);
        }
        globals.status2(" selectMatched found " + out.size() + " matched leaf records");
        return out;
    }

    private static class SizeCompare
    implements Comparator<EquivRecord> {
        private SizeCompare() {
        }

        @Override
        public int compare(EquivRecord s1, EquivRecord s2) {
            return s1.maxSize() - s2.maxSize();
        }
    }
}

