/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.id.IdWriter;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.tool.user.ErrorHighlight;
import com.sun.electric.tool.user.Highlighter;
import java.io.IOException;
import java.io.PrintStream;

class ErrorHighNode
extends ErrorHighlight {
    private final int nodeId;

    public ErrorHighNode(VarContext con, NodeInst ni) {
        super(ni.getParent(), con);
        this.nodeId = ni.getNodeId();
    }

    ErrorHighNode(CellId cellId, int nodeId) {
        super(cellId);
        this.nodeId = nodeId;
    }

    @Override
    boolean containsObject(Cell c, Object obj) {
        EDatabase database = c.getDatabase();
        return this.getCell(database) == c && this.getObject(database) == obj;
    }

    @Override
    Object getObject(EDatabase database) {
        Cell cell = this.getCell(database);
        if (cell == null) {
            return null;
        }
        return cell.getNodeById(this.nodeId);
    }

    public static void writeXmlHeader(String indent, PrintStream ps) {
        ps.println(indent + "<!ELEMENT ERRORTYPEGEOM ANY>");
        ps.println(indent + "<!ATTLIST ERRORTYPEGEOM");
        ps.println(indent + "   geomName CDATA #REQUIRED");
        ps.println(indent + "   cellName CDATA #REQUIRED");
        ps.println(indent + ">");
    }

    @Override
    void writeXmlDescription(String tabs, PrintStream msg, EDatabase database) {
        NodeInst ni = (NodeInst)this.getObject(database);
        msg.append(tabs + "<ERRORTYPEGEOM ");
        msg.append("geomName=\"" + ni.getName() + "\" ");
        msg.append("cellName=\"" + ni.getParent().describe(false) + "\"");
        msg.append(" />\n");
    }

    @Override
    boolean isValid(EDatabase database) {
        return this.getObject(database) != null;
    }

    @Override
    public void addToHighlighter(Highlighter h, EDatabase database) {
        NodeInst ni = (NodeInst)this.getObject(database);
        if (ni != null) {
            h.addElectricObject((ElectricObject)ni, true, ni.getParent());
        }
    }

    @Override
    void write(IdWriter writer) throws IOException {
        this.writeTag(writer, (byte)5);
        writer.writeNodeId(this.nodeId);
    }
}

