/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.richtext;

import java.util.Arrays;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.xmind.ui.color.ColorPicker;
import org.xmind.ui.color.ColorSelection;
import org.xmind.ui.color.IColorSelection;
import org.xmind.ui.color.PaletteContents;
import org.xmind.ui.dialogs.Messages;
import org.xmind.ui.internal.ToolkitImages;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.resources.FontUtils;
import org.xmind.ui.richtext.AlignCenterAction;
import org.xmind.ui.richtext.AlignLeftAction;
import org.xmind.ui.richtext.AlignRightAction;
import org.xmind.ui.richtext.AlignmentGroup;
import org.xmind.ui.richtext.BoldAction;
import org.xmind.ui.richtext.FontAction;
import org.xmind.ui.richtext.IRichTextAction;
import org.xmind.ui.richtext.IRichTextEditViewer;
import org.xmind.ui.richtext.IRichTextRenderer;
import org.xmind.ui.richtext.IndentAction;
import org.xmind.ui.richtext.ItalicAction;
import org.xmind.ui.richtext.OutdentAction;
import org.xmind.ui.richtext.RichTextActionBarContributor;
import org.xmind.ui.richtext.RichTextMessages;
import org.xmind.ui.richtext.RichTextRenderer;
import org.xmind.ui.richtext.RichTextUtils;
import org.xmind.ui.richtext.StrikeoutAction;
import org.xmind.ui.richtext.UnderlineAction;
import org.xmind.ui.viewers.MComboViewer;

public class FullRichTextActionBarContributor
extends RichTextActionBarContributor {
    private static Set<Integer> FONT_SIZE_LIST = new TreeSet<Integer>();
    private IRichTextAction fontAction;
    private MComboViewer fontViewer;
    private MComboViewer sizeViewer;
    private IRichTextAction boldAction;
    private IRichTextAction italicAction;
    private IRichTextAction underlineAction;
    private IRichTextAction strikeoutAction;
    private IRichTextAction alignLeftAction;
    private IRichTextAction alignCenterAction;
    private IRichTextAction alignRightAction;
    private IRichTextAction indentAction;
    private IRichTextAction outdentAction;
    private AlignmentGroup alignGroup;
    private ColorPicker foregroundPicker;
    private ColorPicker backgroundPicker;
    private boolean refreshing = false;

    @Override
    protected void makeActions(IRichTextEditViewer viewer) {
        this.fontAction = new FontAction(viewer);
        this.addRichTextAction(this.fontAction);
        this.boldAction = new BoldAction(viewer);
        this.addRichTextAction(this.boldAction);
        this.italicAction = new ItalicAction(viewer);
        this.addRichTextAction(this.italicAction);
        this.underlineAction = new UnderlineAction(viewer);
        this.addRichTextAction(this.underlineAction);
        this.strikeoutAction = new StrikeoutAction(viewer);
        this.addRichTextAction(this.strikeoutAction);
        this.alignLeftAction = new AlignLeftAction(viewer);
        this.addRichTextAction(this.alignLeftAction);
        this.alignCenterAction = new AlignCenterAction(viewer);
        this.addRichTextAction(this.alignCenterAction);
        this.alignRightAction = new AlignRightAction(viewer);
        this.addRichTextAction(this.alignRightAction);
        this.indentAction = new IndentAction(viewer);
        this.addRichTextAction(this.indentAction);
        this.outdentAction = new OutdentAction(viewer);
        this.addRichTextAction(this.outdentAction);
        this.alignGroup = new AlignmentGroup();
        this.alignGroup.add(this.alignLeftAction);
        this.alignGroup.add(this.alignCenterAction);
        this.alignGroup.add(this.alignRightAction);
        int colorChooserStyle = 5;
        this.foregroundPicker = new ColorPicker(colorChooserStyle, PaletteContents.getDefault(), RichTextMessages.ForegroundAction_text, ToolkitImages.get("foreground.png"));
        this.foregroundPicker.setAutoColor(RichTextUtils.DEFAULT_FOREGROUND.getRGB());
        this.foregroundPicker.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                FullRichTextActionBarContributor.this.foregroundChanged(event);
            }
        });
        this.backgroundPicker = new ColorPicker(colorChooserStyle, PaletteContents.getDefault(), RichTextMessages.BackgroundAction_text, ToolkitImages.get("background.png"));
        this.backgroundPicker.setAutoColor(RichTextUtils.DEFAULT_BACKGROUND.getRGB());
        this.backgroundPicker.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                FullRichTextActionBarContributor.this.backgroundChanged(event);
            }
        });
    }

    private void backgroundChanged(SelectionChangedEvent event) {
        IColorSelection selection = (IColorSelection)event.getSelection();
        Color c = selection.isAutomatic() ? null : ColorUtils.getColor(selection.getColor());
        this.getViewer().getRenderer().setSelectionBackground(c);
    }

    private void foregroundChanged(SelectionChangedEvent event) {
        IColorSelection selection = (IColorSelection)event.getSelection();
        Color c = selection.isAutomatic() ? null : ColorUtils.getColor(selection.getColor());
        this.getViewer().getRenderer().setSelectionForeground(c);
    }

    @Override
    public void fillMenu(IMenuManager menu) {
        menu.add((IAction)this.fontAction);
        menu.add((IAction)this.boldAction);
        menu.add((IAction)this.italicAction);
        menu.add((IAction)this.underlineAction);
        menu.add((IAction)this.strikeoutAction);
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.alignLeftAction);
        menu.add((IAction)this.alignCenterAction);
        menu.add((IAction)this.alignRightAction);
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.indentAction);
        menu.add((IAction)this.outdentAction);
    }

    @Override
    public void fillContextMenu(IMenuManager menu) {
        menu.add((IAction)this.fontAction);
        MenuManager fontMenu = new MenuManager(RichTextMessages.ACTIONBAR_FONT_MENU_TEXT);
        fontMenu.add((IAction)this.boldAction);
        fontMenu.add((IAction)this.italicAction);
        fontMenu.add((IAction)this.underlineAction);
        fontMenu.add((IAction)this.strikeoutAction);
        menu.add((IContributionItem)fontMenu);
        MenuManager alignMenu = new MenuManager(RichTextMessages.ACTIONBAR_ALIGN_MENU_TEXT);
        alignMenu.add((IAction)this.alignLeftAction);
        alignMenu.add((IAction)this.alignCenterAction);
        alignMenu.add((IAction)this.alignRightAction);
        menu.add((IContributionItem)alignMenu);
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.indentAction);
        menu.add((IAction)this.outdentAction);
    }

    @Override
    public void fillToolBar(IToolBarManager toolbar) {
        this.addFontFamilySelector(toolbar);
        this.addFontSizeSelector(toolbar);
        toolbar.add((IAction)this.boldAction);
        toolbar.add((IAction)this.italicAction);
        toolbar.add((IAction)this.underlineAction);
        toolbar.add((IAction)this.strikeoutAction);
        toolbar.add((IContributionItem)new Separator());
        toolbar.add((IContributionItem)this.alignGroup);
        toolbar.add((IContributionItem)new Separator());
        toolbar.add((IAction)this.indentAction);
        toolbar.add((IAction)this.outdentAction);
        toolbar.add((IContributionItem)new Separator());
        toolbar.add((IContributionItem)this.foregroundPicker);
        toolbar.add((IContributionItem)this.backgroundPicker);
    }

    private void addFontFamilySelector(IToolBarManager toolbar) {
        toolbar.add((IContributionItem)new ContributionItem(){

            public void fill(ToolBar parent, int index) {
                ToolItem ti = index < 0 ? new ToolItem(parent, 2) : new ToolItem(parent, 2, index++);
                FullRichTextActionBarContributor.this.fontViewer = new MComboViewer((Composite)parent, 1024);
                GridDataFactory.fillDefaults().grab(true, false).applyTo(FullRichTextActionBarContributor.this.fontViewer.getControl());
                FullRichTextActionBarContributor.this.fontViewer.getControl().setToolTipText(Messages.FullRichTextAction_FontViewer_toolTip);
                FullRichTextActionBarContributor.this.fontViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
                FullRichTextActionBarContributor.this.fontViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
                FullRichTextActionBarContributor.this.fontViewer.setInput(FontUtils.getAvailableFontNames());
                FullRichTextActionBarContributor.this.fontViewer.setSelection((ISelection)new StructuredSelection((Object)RichTextUtils.DEFAULT_FONT.getFontData()[0].getName()));
                FullRichTextActionBarContributor.this.fontViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent event) {
                        if (FullRichTextActionBarContributor.this.refreshing) {
                            return;
                        }
                        FullRichTextActionBarContributor.this.handleFontSelectionChanged(event);
                    }
                });
                ti.setWidth(105);
                ti.setControl(FullRichTextActionBarContributor.this.fontViewer.getControl());
                this.update();
            }
        });
    }

    private void addFontSizeSelector(IToolBarManager toolbar) {
        toolbar.add((IContributionItem)new ContributionItem(){

            public void fill(ToolBar parent, int index) {
                ToolItem ti = index < 0 ? new ToolItem(parent, 2) : new ToolItem(parent, 2, index++);
                FullRichTextActionBarContributor.this.sizeViewer = new MComboViewer((Composite)parent, 1024);
                GridDataFactory.fillDefaults().grab(true, false).applyTo(FullRichTextActionBarContributor.this.sizeViewer.getControl());
                FullRichTextActionBarContributor.this.sizeViewer.getControl().setToolTipText(Messages.FullRichTextAction_FontSizeViewer_toolTip);
                FullRichTextActionBarContributor.this.sizeViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
                FullRichTextActionBarContributor.this.sizeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
                FullRichTextActionBarContributor.this.sizeViewer.setPermitsUnprovidedElement(true);
                if (FONT_SIZE_LIST.isEmpty()) {
                    FONT_SIZE_LIST.addAll(Arrays.asList(8, 9, 10, 11, 12, 13, 14, 16, 18, 20, 22, 24, 36, 48, 56));
                }
                FullRichTextActionBarContributor.this.sizeViewer.setInput(FONT_SIZE_LIST);
                FullRichTextActionBarContributor.this.sizeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent event) {
                        if (FullRichTextActionBarContributor.this.refreshing) {
                            return;
                        }
                        FullRichTextActionBarContributor.this.handleFontSelectionChanged(event);
                    }
                });
                ti.setWidth(45);
                ti.setControl(FullRichTextActionBarContributor.this.sizeViewer.getControl());
                this.update();
            }
        });
    }

    @Override
    public void selectionChanged(ISelection selection, boolean enabled) {
        super.selectionChanged(selection, enabled);
        this.updateColorChoosers(enabled);
        this.updateFontFamilyViewer(enabled);
        this.updateFontSizeViewer(enabled);
    }

    private void updateFontFamilyViewer(boolean enabled) {
        if (this.fontViewer == null || this.fontViewer.getControl().isDisposed()) {
            return;
        }
        this.refreshing = true;
        IRichTextRenderer renderer = this.getViewer().getRenderer();
        this.fontViewer.setSelection((ISelection)new StructuredSelection((Object)renderer.getSelectionFontFace()));
        this.fontViewer.setEnabled(enabled);
        this.refreshing = false;
    }

    private void updateFontSizeViewer(boolean enabled) {
        if (this.sizeViewer == null || this.sizeViewer.getControl().isDisposed()) {
            return;
        }
        this.refreshing = true;
        IRichTextRenderer renderer = this.getViewer().getRenderer();
        this.sizeViewer.setSelection((ISelection)new StructuredSelection((Object)renderer.getSelectionFontSize()));
        this.sizeViewer.setEnabled(enabled);
        this.refreshing = false;
    }

    private void updateColorChoosers(boolean enabled) {
        IRichTextRenderer renderer = this.getViewer().getRenderer();
        StyleRange style = renderer instanceof RichTextRenderer ? ((RichTextRenderer)renderer).getSelectionTextStyle() : null;
        int foregroundType = style == null || style.foreground == null ? 1 : 3;
        this.foregroundPicker.setSelection(new ColorSelection(foregroundType, renderer.getSelectionForeground().getRGB()));
        this.foregroundPicker.getAction().setEnabled(enabled);
        int backgroundType = style == null || style.background == null ? 1 : 3;
        this.backgroundPicker.setSelection(new ColorSelection(backgroundType, renderer.getSelectionBackground().getRGB()));
        this.backgroundPicker.getAction().setEnabled(enabled);
    }

    @Override
    public void dispose() {
        if (this.foregroundPicker != null) {
            this.foregroundPicker.dispose();
        }
        if (this.backgroundPicker != null) {
            this.backgroundPicker.dispose();
        }
        if (this.alignGroup != null) {
            this.alignGroup.dispose();
        }
        if (this.fontViewer != null) {
            this.fontViewer = null;
        }
        if (this.sizeViewer != null) {
            this.sizeViewer = null;
        }
        super.dispose();
    }

    protected void handleFontSelectionChanged(SelectionChangedEvent event) {
        int size;
        IRichTextEditViewer textViewer = this.getViewer();
        if (textViewer == null || textViewer.getControl().isDisposed()) {
            return;
        }
        IRichTextRenderer renderer = textViewer.getRenderer();
        Font selectionFont = renderer.getSelectionFont();
        LocalResourceManager resources = new LocalResourceManager(JFaceResources.getResources());
        Object o = ((IStructuredSelection)event.getSelection()).getFirstElement();
        if (o instanceof String) {
            renderer.setSelectionFont((Font)resources.get((DeviceResourceDescriptor)FontDescriptor.createFrom((FontData[])FontUtils.newName(selectionFont.getFontData(), (String)o))));
        } else if (o instanceof Integer && (size = ((Integer)o).intValue()) > 0) {
            renderer.setSelectionFont((Font)resources.get((DeviceResourceDescriptor)FontDescriptor.createFrom((FontData[])FontUtils.newHeight(selectionFont.getFontData(), size))));
        }
    }
}

