/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.viewers;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.internal.misc.StringMatcher;

public class FileUtils {
    private static final String FILE_PROTOCOL = "file:";
    private static final long K = 1024L;
    private static final long M = 0x100000L;
    private static final int PROCESS_CHECKING_DELAY = 100;

    private FileUtils() {
    }

    public static String fileLengthToString(long length) {
        if (length < 1024L) {
            return String.valueOf(Long.toString(length)) + " B";
        }
        if (length >= 1024L && length < 0x100000L) {
            double tmp = (double)length / 1024.0;
            return String.format("%,.2f KB", tmp);
        }
        double tmp = (double)length / 1048576.0;
        return String.format("%,.2f MB", tmp);
    }

    public static String[] list(File path) {
        return FileUtils.list(path, null);
    }

    public static String[] list(File path, FilenameFilter filter) {
        return FileUtils.list(path, false, filter);
    }

    public static String[] list(File path, boolean extend, final FilenameFilter filter) {
        String pathName = path.getAbsolutePath();
        if (path.isFile() && path.exists()) {
            if (extend) {
                return FileUtils.list(new File(path.getParentFile(), String.valueOf(path.getName()) + "*"), false, filter);
            }
            if (filter == null || filter.accept(path.getParentFile(), path.getName())) {
                return new String[]{pathName};
            }
        } else if (path.isDirectory() && path.exists()) {
            File[] subFiles = path.listFiles(filter);
            if (subFiles != null) {
                ArrayList<String> list = new ArrayList<String>();
                File[] fileArray = subFiles;
                int n = subFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    File subFile = fileArray[n2];
                    list.add(subFile.getAbsolutePath());
                    ++n2;
                }
                return list.toArray(new String[0]);
            }
        } else {
            int index = pathName.lastIndexOf(File.separatorChar);
            if (index >= 0) {
                File dir;
                String dirName = pathName.substring(0, index + 1);
                String filePattern = pathName.substring(index + 1, pathName.length());
                if (extend && !filePattern.endsWith("*")) {
                    filePattern = String.valueOf(filePattern) + "*";
                }
                if ((dir = new File(dirName)).isDirectory()) {
                    final StringMatcher matcher = new StringMatcher(filePattern, true, false);
                    return FileUtils.list(dir, false, new FilenameFilter(){

                        @Override
                        public boolean accept(File dir, String name) {
                            return matcher.match(name) && (filter == null || filter.accept(dir, name));
                        }
                    });
                }
            }
        }
        return new String[0];
    }

    public static boolean launch(String path) {
        File file = path.startsWith(FILE_PROTOCOL) ? new File(path.substring(FILE_PROTOCOL.length())) : new File(path);
        File cwd = new File(System.getProperty("user.home"));
        String os = Platform.getOS();
        if ("win32".equals(os)) {
            if (FileUtils.launchUsingSWT(cwd, path)) {
                return true;
            }
            if (file.isDirectory() && FileUtils.launchUsingShell(cwd, "explorer.exe", FileUtils.quote(path))) {
                return true;
            }
            if (FileUtils.launchUsingShell(cwd, "rundll32.exe", "SHELL32.DLL,ShellExec_RunDLL", FileUtils.quote(path))) {
                return true;
            }
        } else if ("macosx".equals(os)) {
            if (FileUtils.launchUsingSWT(cwd, path)) {
                return true;
            }
            if (FileUtils.launchUsingShell(cwd, "open", path)) {
                return true;
            }
        } else if ("linux".equals(os)) {
            if (FileUtils.launchUsingShell(cwd, "xdg-open", path)) {
                return true;
            }
            if (FileUtils.launchUsingShell(cwd, "gnome-open", path)) {
                return true;
            }
            if (FileUtils.launchUsingSWT(cwd, path)) {
                return true;
            }
        } else if (FileUtils.launchUsingSWT(cwd, path)) {
            return true;
        }
        return false;
    }

    private static String quote(String path) {
        return "\"" + path + "\"";
    }

    private static String getFullPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException iOException) {
            return file.getAbsolutePath();
        }
    }

    private static boolean launchUsingSWT(File cwd, String path) {
        Display display = Display.getCurrent();
        if (display == null) {
            return false;
        }
        return Program.launch((String)path, (String)cwd.getAbsolutePath());
    }

    private static boolean launchUsingShell(File cwd, String ... args) {
        try {
            Process process = Runtime.getRuntime().exec(args, null, cwd);
            FileUtils.waitForProcessToStart();
            try {
                int exitCode = process.exitValue();
                return exitCode == 0;
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                return true;
            }
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private static void waitForProcessToStart() {
        Display display = Display.getCurrent();
        if (display != null) {
            final boolean[] ended = new boolean[]{false};
            display.timerExec(100, new Runnable(){

                @Override
                public void run() {
                    ended[0] = true;
                }
            });
            while (!ended[0] && !display.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        } else {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static boolean show(File file) {
        File cwd = new File(System.getProperty("user.home"));
        String path = FileUtils.getFullPath(file);
        String os = Platform.getOS();
        if ("win32".equals(os)) {
            if (FileUtils.launchUsingShell(cwd, "explorer.exe", "/select,", FileUtils.quote(path))) {
                return true;
            }
        } else if ("macosx".equals(os)) {
            if (FileUtils.launchUsingShell(cwd, "open", "-R", path)) {
                return true;
            }
            if (FileUtils.showUsingScriptForMacOSX(file)) {
                return true;
            }
            if (FileUtils.launchUsingShell(cwd, "open", file.getParent())) {
                return true;
            }
        } else if ("linux".equals(os)) {
            if (FileUtils.launchUsingShell(cwd, "nautilus", path)) {
                return true;
            }
            if (FileUtils.launchUsingShell(cwd, "xdg-open", file.getParent())) {
                return true;
            }
            if (FileUtils.launchUsingShell(cwd, "gnome-open", file.getParent())) {
                return true;
            }
        }
        return FileUtils.launchUsingSWT(cwd, file.getParent());
    }

    private static boolean showUsingScriptForMacOSX(File file) {
        try {
            Process process = Runtime.getRuntime().exec(new String[]{"/usr/bin/osascript"});
            try (PrintStream ps = new PrintStream(process.getOutputStream());){
                ps.println("tell application \"Finder\"");
                ps.println("  set fullpath to POSIX file \"" + file.getAbsolutePath() + "\" as text");
                ps.println("  reveal fullpath");
                ps.println("end tell");
            }
            int exitCode = process.waitFor();
            return exitCode == 0;
        }
        catch (IOException iOException) {
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
    }
}

