/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.decorations;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.widgets.Display;
import org.xmind.gef.draw2d.decoration.AbstractDecoration;
import org.xmind.gef.draw2d.geometry.PrecisionPoint;
import org.xmind.gef.draw2d.geometry.PrecisionRectangle;
import org.xmind.ui.decorations.IArrowDecoration;

public abstract class AbstractArrowDecoration
extends AbstractDecoration
implements IArrowDecoration {
    private static final float[] RECT = new float[4];
    private Color color = null;
    private double angle = 0.0;
    private int width = 1;
    private PrecisionPoint position = new PrecisionPoint();

    protected AbstractArrowDecoration() {
    }

    protected AbstractArrowDecoration(String id) {
        super(id);
    }

    protected abstract void sketch(IFigure var1, org.xmind.gef.draw2d.graphics.Path var2);

    protected boolean usesFill() {
        return false;
    }

    protected boolean usesOutline() {
        return true;
    }

    protected void performPaint(IFigure figure, Graphics graphics) {
        if (this.getColor() == null) {
            return;
        }
        org.xmind.gef.draw2d.graphics.Path shape = new org.xmind.gef.draw2d.graphics.Path((Device)Display.getCurrent());
        this.sketch(figure, shape);
        graphics.setAlpha(this.getAlpha());
        if (this.usesFill()) {
            Color oldBackground = graphics.getBackgroundColor();
            graphics.setBackgroundColor(this.getColor());
            graphics.fillPath((Path)shape);
            graphics.setBackgroundColor(oldBackground);
        }
        if (this.usesOutline()) {
            graphics.setForegroundColor(this.getColor());
            graphics.setLineWidth(this.getWidth());
            graphics.setLineStyle(this.getLineStyle());
            graphics.drawPath((Path)shape);
        }
        shape.dispose();
    }

    protected int getLineStyle() {
        return 1;
    }

    @Override
    public double getAngle() {
        return this.angle;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public PrecisionPoint getPosition() {
        return this.position;
    }

    @Override
    public Rectangle getPreferredBounds(IFigure figure) {
        if (this.usesFill() || this.usesOutline()) {
            this.checkValidation(figure);
            org.xmind.gef.draw2d.graphics.Path shape = new org.xmind.gef.draw2d.graphics.Path((Device)Display.getCurrent());
            this.sketch(figure, shape);
            shape.getBounds(RECT);
            if (Util.isWindows()) {
                float[] autoScaleDown = DPIUtil.autoScaleDown((float[])RECT);
                AbstractArrowDecoration.RECT[0] = autoScaleDown[0];
                AbstractArrowDecoration.RECT[1] = autoScaleDown[1];
                AbstractArrowDecoration.RECT[2] = autoScaleDown[2];
                AbstractArrowDecoration.RECT[3] = autoScaleDown[3];
            }
            shape.dispose();
            return PrecisionRectangle.toDraw2DRectangle((double)RECT[0], (double)RECT[1], (double)RECT[2], (double)RECT[3]).expand(this.getWidth(), this.getWidth());
        }
        return new PrecisionRectangle(this.getPosition(), this.getPosition()).toDraw2DRectangle();
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public void setAngle(IFigure figure, double angle) {
        if (angle == this.angle) {
            return;
        }
        this.angle = angle;
        if (figure != null) {
            figure.revalidate();
            this.repaint(figure);
        }
    }

    @Override
    public void setColor(IFigure figure, Color color) {
        if (color == this.color || color != null && color.equals((Object)this.color)) {
            return;
        }
        this.color = color;
        if (figure != null) {
            this.repaint(figure);
        }
    }

    @Override
    public void setPosition(IFigure figure, PrecisionPoint position) {
        if (position == null || this.position.equals((Object)position)) {
            return;
        }
        this.position.setLocation(position);
        if (figure != null) {
            figure.revalidate();
            this.repaint(figure);
        }
    }

    @Override
    public void setWidth(IFigure figure, int width) {
        if (width == this.width) {
            return;
        }
        this.width = width;
        if (figure != null) {
            figure.revalidate();
            this.repaint(figure);
        }
    }
}

