/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.layers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.xmind.ui.internal.layers.BaseLayer;

public class TitleLayer
extends BaseLayer {
    private List<IFigure> onTop = new ArrayList<IFigure>();

    public void addOnTop(IFigure figure) {
        if (this.onTop.contains(figure)) {
            return;
        }
        this.onTop.add(figure);
        this.repaint();
    }

    public void removeOnTop(IFigure figure) {
        if (!this.onTop.contains(figure)) {
            return;
        }
        this.onTop.remove(figure);
        this.repaint();
    }

    protected void paintChildren(Graphics graphics) {
        Rectangle clip = Rectangle.SINGLETON;
        int i = 0;
        while (i < this.getChildren().size()) {
            IFigure child = (IFigure)this.getChildren().get(i);
            if (!this.onTop.contains(child) && child.isVisible() && child.intersects(graphics.getClip(clip))) {
                graphics.clipRect(child.getBounds());
                child.paint(graphics);
                graphics.restoreState();
            }
            ++i;
        }
        this.paintOnTop(graphics);
    }

    private void paintOnTop(Graphics graphics) {
        Rectangle clip = Rectangle.SINGLETON;
        for (IFigure child : this.onTop) {
            if (!child.isVisible() || !child.intersects(graphics.getClip(clip))) continue;
            graphics.clipRect(child.getBounds());
            child.paint(graphics);
            graphics.restoreState();
        }
    }

    public void remove(IFigure child) {
        super.remove(child);
        this.removeOnTop(child);
    }
}

