/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.properties;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.xmind.core.INumbering;
import org.xmind.core.ITopic;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.ICoreEventRegister;
import org.xmind.gef.Request;
import org.xmind.gef.draw2d.graphics.GraphicsUtils;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.properties.PropertyMessages;
import org.xmind.ui.mindmap.INumberFormatDescriptor;
import org.xmind.ui.mindmap.INumberSeparatorDescriptor;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.properties.MindMapPropertySectionPartBase;
import org.xmind.ui.util.MindMapUtils;
import org.xmind.ui.viewers.MComboViewer;

public class NumberingPropertySectionPart
extends MindMapPropertySectionPartBase {
    private static final Object INHERIT = new Object();
    private MComboViewer formatViewer;
    private Button tieredCheck;
    private MComboViewer depthViewer;
    private MComboViewer separatorViewer;
    private Text prefixInput;
    private Text suffixInput;
    private Text numberLabel;

    @Override
    protected void createContent(Composite parent) {
        Composite line1 = this.createLine(parent);
        line1.setLayout((Layout)this.generateGridLayout(1));
        this.createNumberingFormatLine(line1);
        Composite line2 = this.createLine(parent);
        line2.setLayout((Layout)this.generateGridLayout(1));
        this.createTieredCheckLine(line2);
        Composite line3 = this.createLine(parent);
        line3.setLayout((Layout)this.generateGridLayout(2));
        this.createNumberingDepthLine(line3);
        Composite line4 = this.createLine(parent);
        line4.setLayout((Layout)this.generateGridLayout(2));
        this.createNumberingSeparatorLine(line4);
        Composite line5 = this.createLine(parent);
        line5.setLayout((Layout)this.generateGridLayout(3));
        this.createPrefixAndSuffixLine(line5);
        this.prefixInput.setLayoutData((Object)new GridData(4, 4, true, true));
        this.numberLabel.setLayoutData((Object)new GridData(4, 4, false, true));
        this.suffixInput.setLayoutData((Object)new GridData(4, 4, true, true));
    }

    private GridLayout generateGridLayout(int cols) {
        GridLayout gridLayout = new GridLayout(cols, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 3;
        gridLayout.verticalSpacing = 3;
        return gridLayout;
    }

    private Composite createLine(Composite parent) {
        Composite line = new Composite(parent, 0);
        line.setLayoutData((Object)new GridData(4, 4, true, false));
        return line;
    }

    private void createNumberingFormatLine(Composite parent) {
        this.formatViewer = new MComboViewer(parent, 0);
        this.formatViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, false));
        this.formatViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.formatViewer.setLabelProvider((IBaseLabelProvider)new NumberFormatLabelProvider());
        List<INumberFormatDescriptor> descriptors = MindMapUI.getNumberFormatManager().getDescriptors();
        ArrayList<Object> list = new ArrayList<Object>(descriptors.size() + 1);
        Object separator = new Object();
        INumberFormatDescriptor defaultDescriptor = MindMapUI.getNumberFormatManager().getDescriptor("org.xmind.numbering.none");
        for (INumberFormatDescriptor desc : descriptors) {
            if (desc == null || defaultDescriptor == null || desc == defaultDescriptor) continue;
            list.add(desc);
        }
        if (defaultDescriptor != null) {
            list.add(separator);
            list.add(defaultDescriptor);
        }
        this.formatViewer.setSeparatorImitation(separator);
        this.formatViewer.setInput(list);
        this.formatViewer.addSelectionChangedListener((ISelectionChangedListener)new NumberFormatSelectionChangedListener());
    }

    private void createNumberingSeparatorLine(Composite parent) {
        Label separatorLabel = new Label(parent, 0);
        separatorLabel.setText(PropertyMessages.Separator_label);
        this.separatorViewer = new MComboViewer(parent, 0);
        this.separatorViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, false));
        this.separatorViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.separatorViewer.setLabelProvider((IBaseLabelProvider)new NumberSeparatorLabelProvider());
        List<INumberSeparatorDescriptor> descriptions = MindMapUI.getNumberSeparatorManager().getDescriptors();
        ArrayList<Object> list = new ArrayList<Object>(descriptions.size() + 1);
        Object separator = new Object();
        INumberSeparatorDescriptor defautDescriptor = MindMapUI.getNumberSeparatorManager().getDescriptor("org.xmind.numbering.separator.dot");
        if (defautDescriptor != null) {
            list.add(defautDescriptor);
            list.add(separator);
        }
        for (INumberSeparatorDescriptor desc : descriptions) {
            if (desc == null || defautDescriptor == null || desc == defautDescriptor) continue;
            list.add(desc);
        }
        this.separatorViewer.setSeparatorImitation(separator);
        this.separatorViewer.setInput(list);
        this.separatorViewer.addSelectionChangedListener((ISelectionChangedListener)new SeparatorFormatSelectionChangedListener());
    }

    private void createPrefixAndSuffixLine(Composite parent) {
        this.prefixInput = new Text(parent, 16779268);
        this.prefixInput.setLayoutData((Object)new GridData(4, 2, true, false));
        this.prefixInput.setToolTipText(PropertyMessages.Prefix_toolTip);
        Listener eventHandler = new Listener(){

            public void handleEvent(Event event) {
                if (event.type == 15) {
                    if (event.widget == NumberingPropertySectionPart.this.prefixInput) {
                        NumberingPropertySectionPart.this.prefixInput.selectAll();
                    } else {
                        NumberingPropertySectionPart.this.suffixInput.selectAll();
                    }
                } else if (event.widget == NumberingPropertySectionPart.this.prefixInput) {
                    NumberingPropertySectionPart.this.changePrefix(NumberingPropertySectionPart.this.prefixInput.getText());
                } else {
                    NumberingPropertySectionPart.this.changeSuffix(NumberingPropertySectionPart.this.suffixInput.getText());
                }
            }
        };
        this.prefixInput.addListener(14, eventHandler);
        this.prefixInput.addListener(16, eventHandler);
        this.prefixInput.addListener(15, eventHandler);
        this.numberLabel = new Text(parent, 16779276);
        this.numberLabel.setLayoutData((Object)new GridData(4, 2, false, false));
        this.numberLabel.setEditable(false);
        this.numberLabel.setBackground(this.numberLabel.getDisplay().getSystemColor(25));
        this.suffixInput = new Text(parent, 16779268);
        this.suffixInput.setLayoutData((Object)new GridData(4, 2, true, false));
        this.suffixInput.setToolTipText(PropertyMessages.Suffix_toolTip);
        this.suffixInput.addListener(14, eventHandler);
        this.suffixInput.addListener(16, eventHandler);
        this.suffixInput.addListener(15, eventHandler);
    }

    private void createTieredCheckLine(Composite parent) {
        this.tieredCheck = new Button(parent, 32);
        this.tieredCheck.setText(MindMapMessages.NumberingProperty_TieredCheck_text);
        this.tieredCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NumberingPropertySectionPart.this.changePrepending(NumberingPropertySectionPart.this.tieredCheck.getSelection());
            }
        });
    }

    private void createNumberingDepthLine(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(PropertyMessages.Depth_label);
        this.depthViewer = new MComboViewer(parent, 0);
        this.depthViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, false));
        this.depthViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.depthViewer.setLabelProvider((IBaseLabelProvider)new NumberDepthLabelProvider());
        String[] values = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10"};
        ArrayList<Object> input = new ArrayList<Object>(values.length + 1);
        input.addAll(Arrays.asList(values));
        Object sep = new Object();
        input.add(sep);
        input.add(INHERIT);
        this.depthViewer.setSeparatorImitation(sep);
        this.depthViewer.setInput(input);
        this.depthViewer.addSelectionChangedListener((ISelectionChangedListener)new NumberDepthSelectionChangedListener());
    }

    public void setFocus() {
        if (this.formatViewer != null && !this.formatViewer.getControl().isDisposed()) {
            this.formatViewer.getControl().setFocus();
        }
    }

    public void dispose() {
        super.dispose();
        this.formatViewer = null;
        this.prefixInput = null;
        this.numberLabel = null;
        this.suffixInput = null;
        this.separatorViewer = null;
        this.depthViewer = null;
        this.tieredCheck = null;
    }

    @Override
    protected void doRefresh() {
        Object o = ((IStructuredSelection)this.getCurrentSelection()).getFirstElement();
        if (o instanceof ITopic) {
            Object descriptor;
            ITopic topic = (ITopic)o;
            ITopic parent = topic.getParent();
            if (parent == null) {
                parent = topic;
            }
            INumbering numbering = "attached".equals(topic.getType()) ? parent.getNumbering() : null;
            boolean hasFormat = false;
            if (this.formatViewer != null && !this.formatViewer.getControl().isDisposed()) {
                String format;
                String string = format = numbering == null ? null : numbering.getComputedFormat();
                if (format == null) {
                    format = "org.xmind.numbering.none";
                } else if (parent.getNumbering().getNumberFormat() == null && !topic.getNumbering().isInherited(0)) {
                    format = "org.xmind.numbering.none";
                } else {
                    hasFormat = !"org.xmind.numbering.none".equals(format);
                }
                descriptor = MindMapUI.getNumberFormatManager().getDescriptor(format);
                this.formatViewer.setSelection((ISelection)(descriptor == null ? StructuredSelection.EMPTY : new StructuredSelection(descriptor)));
            }
            if (this.depthViewer != null && !this.depthViewer.getControl().isDisposed()) {
                Object select = INHERIT;
                if (numbering != null) {
                    if (numbering.getDepth() != null) {
                        select = numbering.getDepth();
                    } else if (numbering.getNumberFormat() != null && !numbering.isInherited(1)) {
                        select = "3";
                    }
                    this.depthViewer.setSelection((ISelection)new StructuredSelection(select));
                    if ("org.xmind.numbering.none".equals(numbering.getNumberFormat())) {
                        this.depthViewer.setEnabled(false);
                    } else {
                        this.depthViewer.setEnabled(numbering.getNumberFormat() != null || topic.getNumbering().isInherited(0));
                    }
                }
            }
            if (this.separatorViewer != null && !this.separatorViewer.getControl().isDisposed()) {
                String separator;
                String string = separator = numbering == null ? null : numbering.getComputedSeparator();
                if (separator == null) {
                    separator = "org.xmind.numbering.separator.dot";
                }
                this.separatorViewer.setSelection((ISelection)((descriptor = MindMapUI.getNumberSeparatorManager().getDescriptor(separator)) == null ? StructuredSelection.EMPTY : new StructuredSelection(descriptor)));
            }
            if (this.tieredCheck != null) {
                this.tieredCheck.setSelection(numbering != null && numbering.prependsParentNumbers());
            }
            if (this.prefixInput != null && !this.prefixInput.isDisposed()) {
                String prefix = numbering == null ? null : numbering.getPrefix();
                this.prefixInput.setText(prefix == null ? "" : prefix);
            }
            if (this.suffixInput != null && !this.suffixInput.isDisposed()) {
                String suffix = numbering == null ? null : numbering.getSuffix();
                this.suffixInput.setText(suffix == null ? "" : suffix);
            }
            if (this.numberLabel != null && !this.numberLabel.isDisposed()) {
                String number = MindMapUtils.getNumberingText(topic, hasFormat ? null : "org.xmind.numbering.arabic", hasFormat ? null : "org.xmind.numbering.separator.dot");
                if (number == null || "".equals(number)) {
                    this.numberLabel.setText(" ");
                } else {
                    number = GraphicsUtils.getNormal().constrain(number, 100, JFaceResources.getDefaultFont(), 1);
                    this.numberLabel.setText(number);
                }
                if (hasFormat) {
                    this.numberLabel.setForeground(this.numberLabel.getDisplay().getSystemColor(24));
                } else {
                    this.numberLabel.setForeground(this.numberLabel.getDisplay().getSystemColor(16));
                }
            }
        }
    }

    @Override
    protected void registerEventListener(Object source, ICoreEventRegister register) {
        if (source instanceof ITopic) {
            ITopic parent = ((ITopic)source).getParent();
            if (parent == null) {
                parent = (ITopic)source;
            }
            register.setNextSourceFrom((Object)parent);
            register.register("topicAdd");
            register.register("topicRemove");
            INumbering numbering = parent.getNumbering();
            register.setNextSourceFrom((Object)numbering);
            register.register("numberingFormat");
            register.register("numberingPrefix");
            register.register("numberingSuffix");
            register.register("parentNumberingPrepending");
            register.register("numberingSeparator");
            register.register("numberingDepth");
        }
    }

    @Override
    public void handleCoreEvent(CoreEvent event) {
        String type = event.getType();
        if (("topicAdd".equals(type) || "topicRemove".equals(type)) && !"attached".equals(event.getData())) {
            return;
        }
        super.handleCoreEvent(event);
    }

    private void changeNumberFormat(String formatId) {
        Object o;
        if (formatId != null && (o = ((IStructuredSelection)this.getCurrentSelection()).getFirstElement()) instanceof ITopic) {
            ITopic topic = ((ITopic)o).getParent();
            if (topic == null) {
                topic = (ITopic)o;
            }
            if (formatId.equals(topic.getNumbering().getNumberFormat())) {
                formatId = null;
            }
        }
        this.sendRequest(this.fillTargets(new Request("modify_numbering")).setParameter("numbering.format", (Object)formatId));
    }

    private void changeNumberSeparator(String separatorId) {
        Object o;
        if (separatorId != null && (o = ((IStructuredSelection)this.getCurrentSelection()).getFirstElement()) instanceof ITopic) {
            ITopic topic = ((ITopic)o).getParent();
            if (topic == null) {
                topic = (ITopic)o;
            }
            if (separatorId.equals(topic.getNumbering().getSeparator())) {
                separatorId = null;
            }
        }
        this.sendRequest(this.fillTargets(new Request("modify_numbering")).setParameter("numbering.separator", (Object)separatorId));
    }

    private void changeNumberDepth(String depth) {
        this.sendRequest(this.fillTargets(new Request("modify_numbering")).setParameter("numbering.depth", (Object)depth));
    }

    private void changePrepending(boolean prepend) {
        this.sendRequest(this.fillTargets(new Request("modify_numbering")).setParameter("numbering.prepending", (Object)prepend));
    }

    private void changePrefix(String newPrefix) {
        this.sendRequest(this.fillTargets(new Request("modify_numbering").setParameter("numbering.prefix", (Object)newPrefix)));
    }

    private void changeSuffix(String newSuffix) {
        this.sendRequest(this.fillTargets(new Request("modify_numbering").setParameter("numbering.suffix", (Object)newSuffix)));
    }

    private class NumberDepthLabelProvider
    extends LabelProvider {
        private NumberDepthLabelProvider() {
        }

        public String getText(Object element) {
            if (INHERIT.equals(element)) {
                return MindMapMessages.NumberingProperty_NumberDepthLabelProvider_Inherit_text;
            }
            if (element instanceof String) {
                String depth = (String)element;
                return NLS.bind((String)"{0} {1}", (Object)depth, (Object)MindMapMessages.NumberingProperty_NumberDepthLabelProvider_Levels_text);
            }
            return super.getText(element);
        }
    }

    private class NumberDepthSelectionChangedListener
    implements ISelectionChangedListener {
        private NumberDepthSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (NumberingPropertySectionPart.this.isRefreshing()) {
                return;
            }
            Object o = ((IStructuredSelection)event.getSelection()).getFirstElement();
            if (INHERIT == o) {
                NumberingPropertySectionPart.this.changeNumberDepth(null);
            } else if (o instanceof String) {
                MindMapUIPlugin.getDefault().getUsageDataCollector().increase("NumberDepthCount" + o);
                NumberingPropertySectionPart.this.changeNumberDepth((String)o);
            }
        }
    }

    private class NumberFormatLabelProvider
    extends LabelProvider {
        private NumberFormatLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof INumberFormatDescriptor) {
                INumberFormatDescriptor desc = (INumberFormatDescriptor)element;
                String name = desc.getName();
                String description = desc.getDescription();
                if (description == null || "".equals(description)) {
                    return name;
                }
                return NLS.bind((String)"{0} ({1})", (Object)name, (Object)description);
            }
            return super.getText(element);
        }
    }

    private class NumberFormatSelectionChangedListener
    implements ISelectionChangedListener {
        private NumberFormatSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (NumberingPropertySectionPart.this.isRefreshing()) {
                return;
            }
            Object o = ((IStructuredSelection)event.getSelection()).getFirstElement();
            if (o instanceof INumberFormatDescriptor) {
                MindMapUIPlugin.getDefault().getUsageDataCollector().increase(String.format("Numbering/TypeCount/%s", ((INumberFormatDescriptor)o).getId()));
                NumberingPropertySectionPart.this.changeNumberFormat(((INumberFormatDescriptor)o).getId());
            }
        }
    }

    private class NumberSeparatorLabelProvider
    extends LabelProvider {
        private NumberSeparatorLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof INumberSeparatorDescriptor) {
                INumberSeparatorDescriptor desc = (INumberSeparatorDescriptor)element;
                String name = desc.getName();
                String description = desc.getDescription();
                if (description == null || "".equals(description)) {
                    return name;
                }
                return NLS.bind((String)"{0} ({1})", (Object)name, (Object)description);
            }
            return super.getText(element);
        }
    }

    private class SeparatorFormatSelectionChangedListener
    implements ISelectionChangedListener {
        private SeparatorFormatSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (NumberingPropertySectionPart.this.isRefreshing()) {
                return;
            }
            Object o = ((IStructuredSelection)event.getSelection()).getFirstElement();
            if (o instanceof INumberSeparatorDescriptor) {
                NumberingPropertySectionPart.this.changeNumberSeparator(((INumberSeparatorDescriptor)o).getId());
            }
        }
    }
}

