/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.cathy.internal.css;

import java.lang.reflect.Method;
import java.net.URL;
import org.eclipse.e4.ui.css.core.dom.properties.ICSSPropertyHandler;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.swt.properties.AbstractCSSPropertySWTHandler;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolderRenderer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;
import org.xmind.cathy.internal.css.ICTabFolderRendering;
import org.xmind.cathy.internal.css.ReflectionSupport;

public class CSSPropertyCTabFolderToolBarSWTHandler
extends AbstractCSSPropertySWTHandler {
    public static final ICSSPropertyHandler INSTANCE = new CSSPropertyCTabFolderToolBarSWTHandler();
    private static final String METHOD_SET_CHEVRON_VISIBLE = "setChevronVisible";

    protected void applyCSSProperty(Control control, String property, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        if (!(control instanceof CTabFolder)) {
            return;
        }
        CTabFolder folder = (CTabFolder)control;
        CTabFolderRenderer renderer = folder.getRenderer();
        if (!(renderer instanceof ICTabFolderRendering)) {
            return;
        }
        ICTabFolderRendering tabFolderRendering = (ICTabFolderRendering)renderer;
        Image image = null;
        if (value.getCssValueType() == 1 && ((CSSPrimitiveValue)value).getPrimitiveType() == 20) {
            String imageUrl = ((CSSPrimitiveValue)value).getStringValue();
            ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)new URL(imageUrl.toString()));
            image = JFaceResources.getResources().createImage(imageDescriptor);
        }
        if ("xmind-swt-maximize-image".equals(property)) {
            tabFolderRendering.setMaximizeImage(image);
        } else if ("xmind-swt-minimize-image".equals(property)) {
            tabFolderRendering.setMinimizeImage(image);
        } else if ("xmind-swt-close-image".equals(property)) {
            tabFolderRendering.setCloseImage(image);
        } else if ("xmind-swt-close-hover-image".equals(property)) {
            tabFolderRendering.setClsoeHoverImage(image);
        } else if ("xmind-swt-chevron-visible".equals(property)) {
            ReflectionSupport<CTabFolder> reflect = new ReflectionSupport<CTabFolder>(CTabFolder.class);
            boolean chevronVisible = (Boolean)engine.convert(value, Boolean.class, null);
            Method setChevronVisible = reflect.getMethod(METHOD_SET_CHEVRON_VISIBLE, Boolean.TYPE);
            reflect.executeMethod(setChevronVisible, folder, chevronVisible);
        }
    }

    protected String retrieveCSSProperty(Control control, String property, String pseudo, CSSEngine engine) throws Exception {
        return null;
    }
}

