/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.taskinfo;

import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.xmind.ui.forms.WidgetFactory;
import org.xmind.ui.internal.taskinfo.DateInfo;
import org.xmind.ui.internal.taskinfo.DateInfoPickerViewer;
import org.xmind.ui.internal.taskinfo.DurationEditor;
import org.xmind.ui.internal.taskinfo.DurationInfo;
import org.xmind.ui.internal.taskinfo.EditableValueViewer;
import org.xmind.ui.internal.taskinfo.TaskInfoUtils;
import org.xmind.ui.internal.taskinfo.TaskInfoViewerPart;
import org.xmind.ui.internal.taskinfo.TaskMessages;

@Deprecated
public class DateRangeViewer
extends TaskInfoViewerPart {
    private DateInfoPickerViewer startDatePicker;
    private DurationViewer durationViewer;
    private EndDateViewer endDateViewer;
    private boolean updating = false;

    public void refresh() {
        if (this.startDatePicker == null || this.startDatePicker.getControl().isDisposed() || this.durationViewer == null || this.durationViewer.getControl().isDisposed() || this.endDateViewer == null || this.endDateViewer.getControl().isDisposed()) {
            return;
        }
        this.updating = true;
        boolean enabled = this.getTask() != null;
        DateInfo startDate = TaskInfoUtils.calculateStartDateInfo(this.getTask());
        this.startDatePicker.setSelection((ISelection)(startDate == null ? StructuredSelection.EMPTY : new StructuredSelection((Object)startDate)));
        this.startDatePicker.setEnabled(enabled);
        DateInfo endDate = TaskInfoUtils.calculateEndDateInfo(this.getTask());
        this.endDateViewer.getDatePicker().setSelection((ISelection)(endDate == null ? StructuredSelection.EMPTY : new StructuredSelection((Object)endDate)));
        this.endDateViewer.setEnabled(enabled);
        this.endDateViewer.getEditLink().setEnabled(enabled && startDate != null);
        this.endDateViewer.getDisplay().setText(endDate == null ? TaskMessages.NoDate_text : TaskInfoUtils.formatAll(endDate.date, endDate.allDay));
        DurationInfo userDuration = TaskInfoUtils.getDurationInfo(this.getTask());
        this.durationViewer.getEditor().getButton().setTextForeground(startDate == null && userDuration == null ? this.getInvalidForeground() : this.getValidForeground());
        DurationInfo duration = TaskInfoUtils.calculateDurationExcludeWeekends(this.getTask());
        this.durationViewer.getEditor().getButton().setText(duration.toString());
        this.durationViewer.getEditor().setDays(duration.getDays());
        this.durationViewer.getEditor().setHours(duration.getHours());
        this.durationViewer.setEnabled(enabled);
        this.durationViewer.getDisplay().setText(duration.toString());
        DateInfo userEndDate = TaskInfoUtils.getEndDateInfo(this.getTask());
        boolean showDuration = userEndDate == null;
        this.durationViewer.setEditorVisible(showDuration);
        this.endDateViewer.setEditorVisible(!showDuration);
        this.updating = false;
    }

    protected Control doCreateControl(Composite parent, WidgetFactory factory) {
        Composite composite = factory.createComposite(parent);
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 5;
        gridLayout.horizontalSpacing = 10;
        composite.setLayout((Layout)gridLayout);
        this.createStartDateSection(composite, factory);
        this.createDurationSection(composite, factory);
        this.createEndDateSection(composite, factory);
        return composite;
    }

    private void createStartDateSection(Composite parent, WidgetFactory factory) {
        Label label = factory.createLabel(parent, TaskMessages.StartDate_label);
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, true));
        this.startDatePicker = new DateInfoPickerViewer(parent);
        this.startDatePicker.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.startDatePicker.setInvalidColor(this.getInvalidForeground());
        this.startDatePicker.setValidColor(this.getValidForeground());
        this.startDatePicker.refresh();
        this.startDatePicker.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (DateRangeViewer.this.updating || DateRangeViewer.this.getTask() == null) {
                    return;
                }
                DateRangeViewer.this.changeStartDate((DateInfo)((IStructuredSelection)event.getSelection()).getFirstElement());
            }
        });
    }

    private void createEndDateSection(Composite parent, WidgetFactory factory) {
        Label label = factory.createLabel(parent, TaskMessages.EndDate_label);
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, true));
        this.endDateViewer = new EndDateViewer(parent);
        this.endDateViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
    }

    private void createDurationSection(Composite parent, WidgetFactory factory) {
        Label label = factory.createLabel(parent, TaskMessages.Duration_label);
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, true));
        this.durationViewer = new DurationViewer(parent);
        this.durationViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
    }

    private void changeStartDate(DateInfo date) {
        TaskInfoUtils.changeStartDate(this.getTask(), this.getCommandStack(), date);
    }

    private void changeEndDate(DateInfo date) {
        TaskInfoUtils.changeEndDate(this.getTask(), this.getCommandStack(), date);
    }

    private void changeDuration() {
        int days = this.durationViewer.getEditor().getDays();
        int hours = this.durationViewer.getEditor().getHours();
        while (hours > 23) {
            hours -= 24;
            ++days;
        }
        while (hours < 0) {
            hours += 24;
            --days;
        }
        DurationInfo duration = days == 0 && hours == 0 ? null : new DurationInfo(days, hours);
        TaskInfoUtils.changeDuration(this.getTask(), this.getCommandStack(), duration);
    }

    private void changeDurationActive(boolean active) {
        TaskInfoUtils.changeDurationActive(this.getTask(), this.getCommandStack(), active);
        if (active) {
            this.durationViewer.setFocus();
        } else {
            this.endDateViewer.setFocus();
        }
    }

    private class DurationViewer
    extends EditableValueViewer {
        private DurationEditor editor;

        public DurationViewer(Composite parent) {
            super(parent);
        }

        protected void editLinkActivated() {
            if (DateRangeViewer.this.getTask() == null) {
                return;
            }
            DateRangeViewer.this.changeDurationActive(true);
            this.editor.startEditing();
        }

        protected void createEditor(Composite parent) {
            this.editor = new DurationEditor(parent);
            this.editor.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
            this.editor.addEditorListener(new ICellEditorListener(){

                public void editorValueChanged(boolean oldValidState, boolean newValidState) {
                }

                public void cancelEditor() {
                    DateRangeViewer.this.refresh();
                }

                public void applyEditorValue() {
                    DateRangeViewer.this.changeDuration();
                }
            });
        }

        protected void setEditorFocus() {
            this.editor.setFocus();
        }

        public DurationEditor getEditor() {
            return this.editor;
        }

        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            this.editor.setEnabled(enabled);
        }
    }

    private class EndDateViewer
    extends EditableValueViewer {
        private DateInfoPickerViewer endDatePicker;

        public EndDateViewer(Composite parent) {
            super(parent);
        }

        protected void editLinkActivated() {
            DateRangeViewer.this.changeDurationActive(false);
            Display.getCurrent().asyncExec(new Runnable(){

                public void run() {
                    if (EndDateViewer.this.endDatePicker.getControl().isDisposed()) {
                        return;
                    }
                    EndDateViewer.this.endDatePicker.openDatePicker();
                }
            });
        }

        protected void createEditor(Composite parent) {
            this.endDatePicker = new DateInfoPickerViewer(parent);
            this.endDatePicker.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
            this.endDatePicker.setInvalidColor(DateRangeViewer.this.getInvalidForeground());
            this.endDatePicker.setValidColor(DateRangeViewer.this.getValidForeground());
            this.endDatePicker.refresh();
            this.endDatePicker.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    if (DateRangeViewer.this.updating || DateRangeViewer.this.getTask() == null) {
                        return;
                    }
                    DateRangeViewer.this.changeEndDate((DateInfo)((IStructuredSelection)event.getSelection()).getFirstElement());
                }
            });
        }

        protected void setEditorFocus() {
            this.endDatePicker.getControl().setFocus();
        }

        public DateInfoPickerViewer getDatePicker() {
            return this.endDatePicker;
        }

        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            this.endDatePicker.setEnabled(enabled);
        }
    }
}

