/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.datepicker;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.geometry.Rectangle;
import org.xmind.ui.datepicker.BaseFigure;

public class ArrowFigure
extends BaseFigure {
    public static final int LEFT = 1;
    public static final int RIGHT = 4;
    public static final int UP = 8;
    public static final int DOWN = 32;
    private static final float len = 4.0f;
    private int orientation = 0;

    @Override
    protected void addFeedbackLayers() {
        this.addPressFeedbackLayer();
    }

    @Override
    protected void addContentLayer() {
        this.setContentLayer((IFigure)new Arrow());
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int direction) {
        this.orientation = direction;
        this.repaint();
    }

    private class Arrow
    extends Layer {
        private Arrow() {
        }

        protected void paintFigure(Graphics graphics) {
            super.paintFigure(graphics);
            Rectangle b = this.getBounds();
            float cx = (float)b.x + (float)b.width / 2.0f;
            float cy = (float)b.y + (float)b.height / 2.0f;
            int[] points = ArrowFigure.this.orientation == 1 ? new int[]{(int)(cx - 4.0f), (int)cy, (int)(cx + 4.0f), (int)(cy - 4.0f), (int)(cx + 4.0f), (int)(cy + 4.0f)} : (ArrowFigure.this.orientation == 4 ? new int[]{(int)(cx + 4.0f), (int)cy, (int)(cx - 4.0f), (int)(cy - 4.0f), (int)(cx - 4.0f), (int)(cy + 4.0f)} : (ArrowFigure.this.orientation == 8 ? new int[]{(int)cx, (int)(cy - 4.0f), (int)(cx + 4.0f), (int)(cy + 4.0f), (int)(cx - 4.0f), (int)(cy + 4.0f)} : new int[]{(int)cx, (int)(cy + 4.0f), (int)(cx + 4.0f), (int)(cy - 4.0f), (int)(cx - 4.0f), (int)(cy - 4.0f)}));
            graphics.fillPolygon(points);
            graphics.drawPolygon(points);
        }
    }
}

